/* - GPS full -
 * This example demonstrates the basic usage of a Phidget GPS.  It
 * demonstrates the gathering of GPS information, as well as the time and date
 *
 * Please note that this example was designed to work with only one Phidget
 * GPS connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package GPS;

import com.phidgets.GPSPhidget;
import com.phidgets.PhidgetException;
import javax.swing.JOptionPane;

import listeners.*;

public class GPS extends javax.swing.JFrame {

    private static String runArgs[];
    private GPSPhidget gps;
    private GAttachListener attach_listener;
    private GDetachListener detach_listener;
    private GErrorListener error_listener;
    private GPositionFixStatusChangeListener positionFixStatus_listener;
    private GPositionChangeListener position_listener;

    /** Creates new form GPS */
    public GPS() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        gpsPanel = new javax.swing.JPanel();
        fixStatusChk = new javax.swing.JCheckBox();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        dateTxt = new javax.swing.JTextField();
        timeTxt = new javax.swing.JTextField();
        latTxt = new javax.swing.JTextField();
        longTxt = new javax.swing.JTextField();
        altTxt = new javax.swing.JTextField();
        velTxt = new javax.swing.JTextField();
        headTxt = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("GPS-full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("GPS Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 33, 200, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(43, 36, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        nameTxt.setPreferredSize(new java.awt.Dimension(200, 58));
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 68, 200, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 68, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 144, 200, -1));

        jLabel3.setText("Serial No:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 147, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(97, 180, 200, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(48, 180, -1, -1));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 10, 320, 210));

        gpsPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("GPS Data"));
        gpsPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        fixStatusChk.setText("Fix Acquired");
        fixStatusChk.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        gpsPanel.add(fixStatusChk, new org.netbeans.lib.awtextra.AbsoluteConstraints(25, 27, -1, 20));

        jLabel5.setText("Latitude:");
        gpsPanel.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 140, -1, -1));

        jLabel6.setText("Longitude:");
        gpsPanel.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 182, -1, -1));

        jLabel7.setText("Altitude:");
        gpsPanel.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 222, -1, -1));

        jLabel8.setText("Velocity:");
        gpsPanel.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 261, -1, -1));

        jLabel9.setText("Heading:");
        gpsPanel.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 302, -1, -1));

        jLabel10.setText("Date:");
        gpsPanel.add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 60, -1, -1));

        jLabel11.setText("Time:");
        gpsPanel.add(jLabel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 100, -1, -1));

        dateTxt.setEditable(false);
        gpsPanel.add(dateTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 60, 200, -1));

        timeTxt.setEditable(false);
        gpsPanel.add(timeTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 100, 200, -1));

        latTxt.setEditable(false);
        gpsPanel.add(latTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 140, 200, -1));

        longTxt.setEditable(false);
        gpsPanel.add(longTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 180, 200, -1));

        altTxt.setEditable(false);
        gpsPanel.add(altTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 220, 200, -1));

        velTxt.setEditable(false);
        gpsPanel.add(velTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 260, 200, -1));

        headTxt.setEditable(false);
        gpsPanel.add(headTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(100, 300, 200, -1));

        getContentPane().add(gpsPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 220, 320, 330));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        this.setSize(357, 265);

        gpsPanel.setVisible(false);
        gpsPanel.setEnabled(false);

        fixStatusChk.setEnabled(false);
        dateTxt.setEnabled(false);
        timeTxt.setEnabled(false);
        latTxt.setEnabled(false);
        longTxt.setEnabled(false);
        altTxt.setEnabled(false);
        velTxt.setEnabled(false);
        headTxt.setEnabled(false);

        try {
            gps = new GPSPhidget();

            attach_listener = new GAttachListener(this, this.gpsPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.fixStatusChk, this.dateTxt, this.timeTxt, this.latTxt,
                    this.longTxt, this.altTxt, this.velTxt, this.headTxt);

            detach_listener = new GDetachListener(this, this.gpsPanel, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.fixStatusChk, this.dateTxt, this.timeTxt, this.latTxt,
                    this.longTxt, this.altTxt, this.velTxt, this.headTxt);

            error_listener = new GErrorListener(this);

            positionFixStatus_listener = new GPositionFixStatusChangeListener(this.fixStatusChk, this.latTxt,
                    this.longTxt, this.altTxt, this.velTxt, this.headTxt);

            position_listener = new GPositionChangeListener(this.latTxt,
                    this.longTxt, this.altTxt, this.velTxt, this.headTxt);

            gps.addAttachListener(attach_listener);
            gps.addDetachListener(detach_listener);
            gps.addErrorListener(error_listener);
            gps.addGPSPositionFixStatusChangeListener(positionFixStatus_listener);
            gps.addGPSPositionChangeListener(position_listener);

            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                gps.open(Integer.parseInt(runArgs[0]), null);
            }
            if (runArgs.length > 0) {
                gps.open(Integer.parseInt(runArgs[0]));
            } else {
                gps.openAny();
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new GPS().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField altTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField dateTxt;
    private javax.swing.JCheckBox fixStatusChk;
    private javax.swing.JPanel gpsPanel;
    private javax.swing.JTextField headTxt;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField latTxt;
    private javax.swing.JTextField longTxt;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField timeTxt;
    private javax.swing.JTextField velTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
}
